<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/includes/functions.php';
require_once __DIR__ . '/api/esim-api.php';

$countryCode = $_GET['code'] ?? '';
if (empty($countryCode)) {
    header('Location: /');
    exit;
}

// Get country name from static list
$countries = require __DIR__ . '/data/countries.php';
$countryName = '';
$countryNameFa = '';
foreach ($countries as $country) {
    if (strtoupper($country['iso']) == strtoupper($countryCode)) {
        $countryName = $country['name'];
        $countryNameFa = $country['name_fa'];
        break;
    }
}

if (empty($countryName)) {
    header('Location: /');
    exit;
}

// Try to get packages from API
$api = new eSIMAPI();
$packagesData = $api->getCountryPackages(strtoupper($countryCode));
$packages = [];
$apiError = false;

if ($packagesData && isset($packagesData['obj']['packageList'])) {
    $packages = $packagesData['obj']['packageList'];
} else {
    $apiError = true;
    error_log("Failed to get packages for country: " . $countryCode);
}

$pageTitle = 'بسته‌های ' . $countryNameFa;
include __DIR__ . '/includes/header.php';
?>

<style>
.breadcrumb {
    padding: 15px 0;
    color: #666;
    font-size: 14px;
}

.breadcrumb a {
    color: #667eea;
    text-decoration: none;
}

.breadcrumb i {
    margin: 0 8px;
    font-size: 12px;
}

.country-header {
    background: white;
    border-radius: 15px;
    padding: 40px;
    margin-bottom: 30px;
    box-shadow: 0 3px 15px rgba(0, 0, 0, 0.1);
    text-align: center;
}

.country-flag-large {
    width: 150px;
    height: 100px;
    object-fit: cover;
    border-radius: 10px;
    box-shadow: 0 3px 15px rgba(0, 0, 0, 0.2);
    margin-bottom: 20px;
}

.country-header h1 {
    color: #667eea;
    font-size: 32px;
    margin-bottom: 10px;
}

.packages-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(320px, 1fr));
    gap: 25px;
    margin-bottom: 50px;
}

.package-card {
    background: white;
    border-radius: 12px;
    padding: 25px;
    box-shadow: 0 3px 15px rgba(0, 0, 0, 0.1);
    transition: transform 0.3s, box-shadow 0.3s;
    position: relative;
}

.package-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 25px rgba(0, 0, 0, 0.15);
}

.package-badge {
    position: absolute;
    top: 15px;
    left: 15px;
    background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
    color: white;
    padding: 5px 15px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: bold;
}

.package-header h3 {
    color: #333;
    font-size: 18px;
    margin-bottom: 15px;
    padding-bottom: 15px;
    border-bottom: 2px solid #f0f0f0;
}

.package-details {
    margin: 15px 0;
}

.detail-item {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 10px 0;
    color: #666;
}

.detail-item i {
    color: #667eea;
    width: 20px;
}

.package-description {
    background: #f8f9fa;
    padding: 15px;
    border-radius: 8px;
    margin: 15px 0;
    font-size: 14px;
    line-height: 1.6;
    color: #666;
}

.countries-link {
    color: #667eea;
    text-decoration: none;
    font-weight: 600;
}

.countries-link:hover {
    text-decoration: underline;
}

.package-price {
    text-align: center;
    margin: 20px 0;
}

.price-usd {
    color: #999;
    font-size: 14px;
    margin-bottom: 5px;
}

.price-usd del {
    color: #ccc;
}

.price-irr {
    font-size: 28px;
    font-weight: bold;
    color: #667eea;
}

.btn {
    display: block;
    width: 100%;
    padding: 14px;
    text-align: center;
    text-decoration: none;
    border-radius: 8px;
    font-weight: bold;
    transition: all 0.3s;
}

.btn-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
}

.btn-block {
    display: block;
    width: 100%;
}

.no-packages {
    text-align: center;
    padding: 60px 20px;
    background: white;
    border-radius: 15px;
    box-shadow: 0 3px 15px rgba(0, 0, 0, 0.1);
}

.no-packages i {
    font-size: 60px;
    color: #ddd;
    margin-bottom: 20px;
}

.no-packages h2 {
    color: #333;
    margin-bottom: 15px;
}

.no-packages p {
    color: #666;
    margin: 10px 0;
}

/* Modal Styles */
.countries-modal {
    display: none;
    position: fixed;
    z-index: 1000;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.5);
}

.countries-modal-content {
    background-color: white;
    margin: 5% auto;
    padding: 0;
    border-radius: 15px;
    width: 90%;
    max-width: 600px;
    max-height: 80vh;
    overflow: hidden;
    box-shadow: 0 5px 30px rgba(0, 0, 0, 0.3);
}

.countries-modal-header {
    padding: 20px 25px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.countries-modal-header h3 {
    margin: 0;
    font-size: 20px;
}

.countries-modal-close {
    background: none;
    border: none;
    color: white;
    font-size: 32px;
    cursor: pointer;
    line-height: 1;
}

.countries-modal-body {
    padding: 25px;
    max-height: 60vh;
    overflow-y: auto;
}

.countries-list {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
    gap: 15px;
}

.country-item {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 10px;
    background: #f8f9fa;
    border-radius: 8px;
}

.country-item img {
    width: 40px;
    height: 27px;
    object-fit: cover;
    border-radius: 4px;
}

@media (max-width: 768px) {
    .packages-grid {
        grid-template-columns: 1fr;
    }
    
    .countries-list {
        grid-template-columns: 1fr;
    }
}
</style>

<div class="container">
    <div class="breadcrumb">
        <a href="/">خانه</a>
        <i class="fas fa-chevron-left"></i>
        <span><?php echo htmlspecialchars($countryNameFa); ?></span>
    </div>

    <div class="country-header">
        <img src="https://flagcdn.com/w320/<?php echo strtolower($countryCode); ?>.png" 
             alt="<?php echo htmlspecialchars($countryName); ?>"
             class="country-flag-large"
             onerror="this.src='https://via.placeholder.com/150x100?text=<?php echo $countryCode; ?>'">
        <h1>بسته‌های eSIM <?php echo htmlspecialchars($countryNameFa); ?></h1>
        <p style="color: #666;"><?php echo count($packages); ?> بسته موجود</p>
    </div>

    <div class="packages-grid" id="packagesGrid">
        <?php foreach ($packages as $package): 
            // Convert API price from cents to dollars
            $priceUsd = $package['price'] / 10000;
            $priceIrr = usdToIrr($priceUsd);
            
            // Convert volume from bytes to GB
            $volumeGB = $package['volume'] / 1073741824; // 1024^3
            $volumeMB = round($volumeGB * 1024);
            
            // Format data display
            if ($volumeGB >= 1) {
                $dataDisplay = round($volumeGB, 1) . ' GB';
            } else {
                $dataDisplay = round($volumeMB) . ' MB';
            }
            
            $durationDays = $package['duration'];
            $packageName = $package['name'];
            $packageCode = $package['packageCode'];
            $speed = $package['speed'] ?? '4G/5G';
            $isFavorite = !empty($package['favorite']);
            
            // Build description
            $locationNames = [];
            if (isset($package['locationNetworkList']) && is_array($package['locationNetworkList'])) {
                foreach ($package['locationNetworkList'] as $loc) {
                    if (isset($loc['locationName'])) {
                        $locationNames[] = $loc['locationName'];
                    }
                }
            }
            
            $locationCount = count($locationNames);
            $modalId = 'countriesModal' . $packageCode;
            
            $description = "";
            if ($locationCount > 3) {
                $description = "این بسته برای استفاده در <a href='javascript:void(0)' class='countries-link' onclick='showCountriesModal(\"{$modalId}\")'>$locationCount کشور</a> مختلف قابل استفاده است. ";
            } elseif ($locationCount > 0) {
                $description = "قابل استفاده در: " . implode('، ', $locationNames) . ". ";
            }
            
            if (isset($package['activeType'])) {
                if ($package['activeType'] == 1) {
                    $description .= "فعال‌سازی بلافاصله پس از نصب. ";
                } elseif ($package['activeType'] == 2) {
                    $description .= "فعال‌سازی هنگام اولین اتصال به شبکه. ";
                }
            }
            
            if (isset($package['smsStatus']) && $package['smsStatus'] > 0) {
                $description .= "دریافت SMS پشتیبانی می‌شود. ";
            }
            
            if (empty($description)) {
                $description = "بسته اینترنت {$dataDisplay} با اعتبار {$durationDays} روزه و سرعت {$speed}.";
            }
        ?>
        <div class="package-card">
            <?php if ($isFavorite): ?>
            <div class="package-badge">محبوب</div>
            <?php endif; ?>
            <div class="package-header">
                <h3><?php echo htmlspecialchars($packageName); ?></h3>
            </div>
            <div class="package-details">
                <div class="detail-item">
                    <i class="fas fa-database"></i>
                    <span><strong>حجم:</strong> <?php echo $dataDisplay; ?></span>
                </div>
                <div class="detail-item">
                    <i class="fas fa-calendar"></i>
                    <span><strong>مدت:</strong> <?php echo $durationDays; ?> روز</span>
                </div>
                <div class="detail-item">
                    <i class="fas fa-signal"></i>
                    <span><strong>شبکه:</strong> <?php echo htmlspecialchars($speed); ?></span>
                </div>
            </div>
            
            <div class="package-description">
                <?php echo $description; ?>
            </div>
            <div class="package-price">
                <div class="price-usd">
                    <del>$<?php echo number_format($priceUsd, 2); ?></del>
                </div>
                <div class="price-irr">
                    <?php echo formatPrice($priceIrr); ?> تومان
                </div>
            </div>
            <a href="/checkout.php?package=<?php echo $packageCode; ?>&country=<?php echo $countryCode; ?>" class="btn btn-primary btn-block">
                <i class="fas fa-shopping-cart"></i>
                خرید این eSIM
            </a>
        </div>
        
        <!-- Modal for countries list -->
        <?php if ($locationCount > 3): ?>
        <div id="<?php echo $modalId; ?>" class="countries-modal">
            <div class="countries-modal-content">
                <div class="countries-modal-header">
                    <h3>
                        <i class="fas fa-globe"></i>
                        کشورهای قابل استفاده
                    </h3>
                    <button class="countries-modal-close" onclick="closeCountriesModal('<?php echo $modalId; ?>')">&times;</button>
                </div>
                <div class="countries-modal-body">
                    <div class="countries-list">
                        <?php 
                        foreach ($locationNames as $locationName): 
                            $locationCode = '';
                            foreach ($package['locationNetworkList'] as $loc) {
                                if ($loc['locationName'] == $locationName && isset($loc['locationCode'])) {
                                    $locationCode = strtolower($loc['locationCode']);
                                    break;
                                }
                            }
                        ?>
                        <div class="country-item">
                            <?php if ($locationCode): ?>
                            <img src="https://flagcdn.com/w40/<?php echo $locationCode; ?>.png" 
                                 alt="<?php echo htmlspecialchars($locationName); ?>"
                                 onerror="this.style.display='none'">
                            <?php endif; ?>
                            <span><?php echo htmlspecialchars($locationName); ?></span>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
        
        <?php endforeach; ?>
    </div>

    <?php if ($apiError): ?>
    <div class="no-packages">
        <i class="fas fa-exclamation-triangle"></i>
        <h2>خطا در دریافت اطلاعات</h2>
        <p>متأسفانه در حال حاضر امکان دریافت بسته‌ها از سرور وجود ندارد.</p>
        <p>لطفاً چند دقیقه دیگر دوباره تلاش کنید.</p>
        <a href="/" class="btn btn-primary">بازگشت به صفحه اصلی</a>
    </div>
    <?php elseif (empty($packages)): ?>
    <div class="no-packages">
        <i class="fas fa-box-open"></i>
        <h2>بسته‌ای یافت نشد</h2>
        <p>متأسفانه در حال حاضر بسته‌ای برای این کشور موجود نیست.</p>
        <a href="/" class="btn btn-primary">بازگشت به صفحه اصلی</a>
    </div>
    <?php endif; ?>
</div>

<script>
function showCountriesModal(modalId) {
    document.getElementById(modalId).style.display = 'block';
}

function closeCountriesModal(modalId) {
    document.getElementById(modalId).style.display = 'none';
}

// Close modal when clicking outside
window.onclick = function(event) {
    if (event.target.classList.contains('countries-modal')) {
        event.target.style.display = 'none';
    }
}
</script>

<?php include __DIR__ . '/includes/footer.php'; ?>
